hght_long <- read.table('C:/GRE2016/Data/bgs_height_long.dat', na.string='.')

# Give the variable names
names(hght_long)<-c('id', 'age', 'hght')

summary(hght_long)
attach(hght_long)

library(nlme)

# Jenss-Bayley Growth Model
hght.jb.nlme <- nlme(hght~b_1i+b_2i*(age/12)+b_3i*(exp(b_4i*(age/12))-1),
                      data=hght_long,
                      fixed=b_1i+b_2i+b_3i+b_4i~1,
                      random=b_1i+b_2i+b_3i+b_4i~1,
                      groups=~id,
                      start=c(50, 10, -18, -2),
                      na.action=na.omit)
                       
summary(hght.jb.nlme)

#Nonlinear mixed-effects model fit by maxibetam likelihood
#  Model: hght ~ b_1i + b_2i * (age/12) + b_3i * (exp(b_4i * (age/12)) -      1) 
# Data: hght_long 
#       AIC     BIC    logLik
#  2005.179 2070.65 -987.5895
#
#Random effects:
# Forbetala: list(b_1i ~ 1, b_2i ~ 1, b_3i ~ 1, b_4i ~ 1)
# Level: id
# Structure: General positive-definite, Log-Cholesky parametrization
#         StdDev    Corr                
#b_1i     2.6774379 b_1i   b_2i   b_3i  
#b_2i     0.8718004  0.319              
#b_3i     3.4101698  0.491  0.449       
#b_4i     0.2746959 -0.120 -0.275 -0.642
#Residual 0.8041708                     
#
#Fixed effects: b_1i + b_2i + b_3i + b_4i ~ 1 
#         Value Std.Error  DF   t-value p-value
#b_1i  50.99058 0.3422308 495 148.99470       0
#b_2i   9.31951 0.1607690 495  57.96834       0
#b_3i -17.84859 0.4814531 495 -37.07234       0
#b_4i  -2.13260 0.0769088 495 -27.72897       0
# Correlation: 
#     b_1i   b_2i   b_3i  
#b_2i  0.022              
#b_3i  0.376  0.607       
#b_4i  0.263 -0.642 -0.536
#
#Standardized Within-Group Residuals:
#         Min           Q1          Med           Q3          Max 
#-3.482308335 -0.518362303  0.001328493  0.517547575  2.744933632 
#
#Number of Observations: 581
#Number of Groups: 83 



# Jenss-Bayley Growth Model fit by first-order approximation
hght.jb.nlme.fo <- nlme(hght~(beta_1+d_1i)+(beta_2+d_2i)*(age/12)+(beta_3+d_3i)*(exp(beta_4*(age/12))-1)+d_4i*(beta_3*(age/12)*exp(beta_4*(age/12))),
                      data=hght_long,
                      fixed=beta_1+beta_2+beta_3+beta_4~1,
                      random=d_1i+d_2i+d_3i+d_4i~1,
                      groups=~id,
                      start=c(50, 10, -18, -2),
                      na.action=na.omit)

summary(hght.jb.nlme.fo)

#Nonlinear mixed-effects model fit by maxibetam likelihood
#  Model: hght ~ (beta_1 + d_1i) + (beta_2 + d_2i) * (age/12) + (beta_3 + d_3i) *      (exp(beta_4 * (age/12)) - 1) + d_4i * (beta_3 * (age/12) * exp(beta_4 *      (age/12))) 
# Data: hght_long 
#       AIC      BIC    logLik
#  2005.213 2070.684 -987.6063
#
#Random effects:
# Forbetala: list(d_1i ~ 1, d_2i ~ 1, d_3i ~ 1, d_4i ~ 1)
# Level: id
# Structure: General positive-definite, Log-Cholesky parametrization
#         StdDev    Corr                
#d_1i     2.7167245 d_1i   d_2i   d_3i  
#d_2i     0.8928475  0.267              
#d_3i     3.3840012  0.482  0.433       
#d_4i     0.2775613  0.027 -0.299 -0.525
#Residual 0.8027912                     
#
#Fixed effects: beta_1 + beta_2 + beta_3 + beta_4 ~ 1 
#           Value Std.Error  DF   t-value p-value
#beta_1  50.96847 0.3478277 495 146.53366       0
#beta_2   9.33387 0.1602771 495  58.23580       0
#beta_3 -17.83233 0.4667396 495 -38.20616       0
#beta_4  -2.11293 0.0752802 495 -28.06752       0
# Correlation: 
#     beta_1   beta_2   beta_3  
#beta_2 -0.006              
#beta_3  0.385  0.578       
#beta_4  0.326 -0.634 -0.462
#
#Standardized Within-Group Residuals:
#        Min          Q1         Med          Q3         Max 
#-3.43001316 -0.51726840 -0.02358615  0.52150585  2.78477132 
#
#Number of Observations: 581
#Number of Groups: 83 

# Spline Growth Model with Estimated Knot Point and Variability 
hght.spline.nlme <- nlme(hght~b_1i+b_2i*(pmin(0,age-b_4i))+b_3i*(pmax(0,age-b_4i)),
                      data=hght_long,
                      fixed=b_1i+b_2i+b_3i+b_4i~1,
                      random=b_1i+b_2i+b_3i+b_4i~1,
                      groups=~id,
                      start=c(60, 5, 2, 8),
                      na.action=na.omit)

summary(hght.spline.nlme)

#Nonlinear mixed-effects model fit by maxibetam likelihood
#  Model: hght ~ b_1i + b_2i * (pmin(0, age - b_4i)) + b_3i * (pmax(0,      age - b_4i)) 
# Data: hght_long 
#       AIC      BIC    logLik
#  2293.045 2358.517 -1131.523
#
#Random effects:
# Forbetala: list(b_1i ~ 1, b_2i ~ 1, b_3i ~ 1, b_4i ~ 1)
# Level: id
# Structure: General positive-definite, Log-Cholesky parametrization
#         StdDev     Corr                
#b_1i     2.70806946 b_1i   b_2i   b_3i  
#b_2i     0.28601240  0.107              
#b_3i     0.05565713  0.476  0.443       
#b_4i     0.29339376  0.793 -0.506  0.238
#Residual 1.21258824                     
#
#Fixed effects: b_1i + b_2i + b_3i + b_4i ~ 1 
#        Value Std.Error  DF   t-value p-value
#b_1i 71.92534 0.3602892 495 199.63224       0
#b_2i  2.51075 0.0540702 495  46.43494       0
#b_3i  0.90033 0.0098053 495  91.82080       0
#b_4i  7.72076 0.1427390 495  54.09005       0
# Correlation: 
#     b_1i   b_2i   b_3i  
#b_2i -0.153              
#b_3i  0.028  0.168       
#b_4i  0.617 -0.685 -0.189
#
#Standardized Within-Group Residuals:
#         Min           Q1          Med           Q3          Max 
#-2.639200077 -0.530113519  0.009132438  0.574318988  2.623445401 
#
#Number of Observations: 581
#Number of Groups: 83 


# Spline Growth Model with Estimated Knot Point 
hght.spline.nlme.no <- nlme(hght~b_1i+b_2i*(pmin(0,age-gamma))+b_3i*(pmax(0,age-gamma)),
                      data=hght_long,
                      fixed=b_1i+b_2i+b_3i+gamma~1,
                      random=b_1i+b_2i+b_3i~1,
                      groups=~id,
                      start=c(60, 5, 2, 8),
                      na.action=na.omit)

summary(hght.spline.nlme.no)

#Nonlinear mixed-effects model fit by maxibetam likelihood
#  Model: hght ~ b_1i + b_2i * (pmin(0, age - gamma)) + b_3i * (pmax(0,      age - gamma)) 
# Data: hght_long 
#       AIC      BIC    logLik
#  2287.346 2335.359 -1132.673
#
#Random effects:
# Forbetala: list(b_1i ~ 1, b_2i ~ 1, b_3i ~ 1)
# Level: id
# Structure: General positive-definite, Log-Cholesky parametrization
#         StdDev     Corr       
#b_1i     2.43555766 b_1i  b_2i 
#b_2i     0.26036627 0.418      
#b_3i     0.05674639 0.548 0.550
#Residual 1.21623023            
#
#Fixed effects: b_1i + b_2i + b_3i + gamma ~ 1 
#         Value Std.Error  DF   t-value p-value
#b_1i  71.82716 0.3353841 495 214.16390       0
#b_2i   2.53762 0.0525520 495  48.28783       0
#b_3i   0.90117 0.0098949 495  91.07447       0
#gamma  7.62649 0.1372391 495  55.57085       0
# Correlation: 
#      b_1i   b_2i   b_3i  
#b_2i  -0.040              
#b_3i   0.041  0.199       
#gamma  0.514 -0.650 -0.234
#
#Standardized Within-Group Residuals:
#        Min          Q1         Med          Q3         Max 
#-2.64758403 -0.55058441  0.01787728  0.58480214  2.59728431 
#
#Number of Observations: 581
#Number of Groups: 83 

anova(hght.spline.nlme, hght.spline.nlme.no)
