# Load the data
hght_wide<-read.table('C:/GRE2016/Data/bgs_height_wide.dat', na.string='.')

# Give the variable names
names(hght_wide)<-c('id', 'hght01', 'hght03', 'hght06', 'hght09', 'hght12', 
                          'hght15', 'hght18', 'hght24', 'hght36')

library(OpenMx)

################# Jenss-Bayley Growth Model through Taylor Series Expansion ################# 

jb.hght.omx <- mxModel("Jenss Bayley Growth Model, Path Specification",
 type="RAM", mxData(observed=hght_wide, type="raw"),
 manifestVars=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 latentVars=c('eta_1','eta_2','eta_3','eta_4'),

# Residual Variances
mxPath( from=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'), 
 arrows=2, free=TRUE, values=10, labels='theta'),

# Latent Variable Covariances 
mxPath(from=c('eta_1','eta_2','eta_3','eta_4'),connect='unique.pairs',
 arrows=2, free=TRUE, values = c(1,0,0,0,1,0,0,1,0,1),
 labels=c('psi_11','psi_21','psi_31','psi_41','psi_22','psi_32','psi_42','psi_33','psi_43','psi_44')),

# Factor Loadings
mxPath(from='eta_1', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE, values=1),

mxPath(from='eta_2', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE, values=c(.0833, .25, .5, .75, 1, 1.25, 1.5, 2, 3)),

mxPath(from='eta_3', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE,
 labels=c('L3[1,1]', 'L3[2,1]', 'L3[3,1]', 'L3[4,1]', 'L3[5,1]', 'L3[6,1]', 'L3[7,1]', 'L3[8,1]', 'L3[9,1]')),

mxPath(from='eta_4', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE,
 labels=c('L4[1,1]', 'L4[2,1]', 'L4[3,1]', 'L4[4,1]', 'L4[5,1]', 'L4[6,1]', 'L4[7,1]', 'L4[8,1]', 'L4[9,1]')),

# Latent Variable Means
mxPath(from='one', to=c('eta_1','eta_2','eta_3'),
 arrows=1, free=TRUE, values=c(50, 10, -15),
 labels=c('alpha_1','alpha_2','alpha_3')),

# Functional Constraints
mxMatrix('Full', 9, 1, free = FALSE, values = 1, labels = 'number1', name = 'one'),
mxMatrix('Full', 9, 1, free = TRUE, values = -15, labels = 'alpha_3', name = 'a_3'),
mxMatrix('Full', 9, 1, free = TRUE, values = -2, labels = 'alpha_4', name = 'a_4'),
mxMatrix('Full', 9, 1, free = FALSE, values = c(.0833,.25,.5,.75,1,1.25,1.5,2,3), name = 'time'),

mxAlgebra((exp(a_4 * time)-one), name='L3'),
mxAlgebra(a_3*time*exp(a_4*time), name='L4')

) # Close Model 

jb.hght.fit <- mxRun(jb.hght.omx)

summary(jb.hght.fit)

#free parameters:
#      name matrix    row    col     Estimate  Std.Error
#1    theta      S hght01 hght01   0.64361068 0.05285846
#2   psi_11      S  eta_1  eta_1   7.40983185 1.51601209
#3   psi_21      S  eta_1  eta_2   0.63918570 0.52741813
#4   psi_22      S  eta_2  eta_2   0.80917244 0.33976726
#5   psi_31      S  eta_1  eta_3   4.44830601 1.57227660
#6   psi_32      S  eta_2  eta_3   1.34529809 0.84805468
#7   psi_33      S  eta_3  eta_3  11.62504227 3.00640157
#8   psi_41      S  eta_1  eta_4   0.02957294 0.26218739
#9   psi_42      S  eta_2  eta_4  -0.07774225 0.14327950
#10  psi_43      S  eta_3  eta_4  -0.48781365 0.38261606
#11  psi_44      S  eta_4  eta_4   0.07590980 0.07914543
#12 alpha_1      M      1  eta_1  51.07597943 0.35192099
#13 alpha_2      M      1  eta_2   9.29555541 0.17381207
#14 alpha_3      M      1  eta_3 -17.83600004 0.49089353
#15 alpha_4    a_4      1      1  -2.07644521 0.08446366
#
#observed statistics:  581 
#estimated parameters:  15 
#degrees of freedom:  566 
#-2 log likelihood:  1974.936 
#number of observations:  83 
#Information Criteria: 
#      |  df Penalty  |  Parameters Penalty  |  Sample-Size Adjusted
#AIC:       842.9355               2004.936                       NA
#BIC:      -526.1283               2041.218                 1993.904
#Some of your fit indices are missing.
#  To get them, fit saturated and independence models, and include them with
#  summary(yourModel, SaturatedLikelihood=..., IndependenceLikelihood=...). 
#timestamp: 2014-11-07 14:48:43 
#wall clock time: 0.287029 secs 
#optimizer:  CSOLNP 
#OpenMx version number: 2.0.0.3838 
#Need help?  See help(mxSummary) 








################# Spline Growth Model with Variation in Knot Point through Taylor Series Expansion ################# 

spl.hght.omx <- mxModel("Spline Growth Model, Path Specification",
 type="RAM", mxData(observed=hght_wide, type="raw"),
 manifestVars=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 latentVars=c('eta_1','eta_2','eta_3','eta_4'),

# Residual Variances
mxPath( from=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'), 
 arrows=2, free=TRUE, values=10, labels='theta'),

# Latent Variable Covariances 
mxPath(from=c('eta_1','eta_2','eta_3','eta_4'),connect='unique.pairs',
 arrows=2, free=TRUE, values = c(1,0,0,0,1,0,0,1,0,1),
 labels=c('psi_11','psi_21','psi_31','psi_41','psi_22','psi_32','psi_42','psi_33','psi_43','psi_44')),

# Factor Loadings
mxPath(from='eta_1', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE, values=1),

mxPath(from='eta_2', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE, values=c(1, 3, 6, 9, 12, 15, 18, 24, 36)),

mxPath(from='eta_3', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE,
 labels=c('L3[1,1]', 'L3[2,1]', 'L3[3,1]', 'L3[4,1]', 'L3[5,1]', 'L3[6,1]', 'L3[7,1]', 'L3[8,1]', 'L3[9,1]')),

mxPath(from='eta_4', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE,
 labels=c('L4[1,1]', 'L4[2,1]', 'L4[3,1]', 'L4[4,1]', 'L4[5,1]', 'L4[6,1]', 'L4[7,1]', 'L4[8,1]', 'L4[9,1]')),

# Latent Variable Means
mxPath(from='one', to=c('eta_1','eta_2','eta_3'),
 arrows=1, free=TRUE, values=c(70, 2, 1),
 labels=c('alpha_1','alpha_2','alpha_3')),

# Functional Constraints
mxMatrix('Full', 9, 1, free = TRUE, values = 1, labels = 'alpha_3', name = 'a_3'),
mxMatrix('Full', 9, 1, free = TRUE, values = 8, labels = 'alpha_4', name = 'a_4'),
mxMatrix('Full', 9, 1, free = FALSE, values = c(1,3,6,9,12,15,18,24,36), name = 'time'),

mxAlgebra(sqrt((time-a_4)*(time-a_4)), name='L3'),
mxAlgebra((a_3*time-a_3*a_4)/sqrt((time-a_4)*(time-a_4)), name='L4')

) # Close Model 

spl.hght.fit <- mxRun(spl.hght.omx)

summary(spl.hght.fit)

#free parameters:
#      name matrix    row    col     Estimate   Std.Error
#1    theta      S hght01 hght01  1.661473452 0.137617512
#2   psi_11      S  eta_1  eta_1  4.522085525 0.896154141
#3   psi_21      S  eta_1  eta_2  0.034659381 0.059450691
#4   psi_22      S  eta_2  eta_2  0.003695642 0.007348189
#5   psi_31      S  eta_1  eta_3  0.007781027 0.056665087
#6   psi_32      S  eta_2  eta_3 -0.001170548 0.006771187
#7   psi_33      S  eta_3  eta_3  0.001056559 0.006856148
#8   psi_41      S  eta_1  eta_4  0.113699538 0.242663524
#9   psi_42      S  eta_2  eta_4 -0.117773768 0.025809320
#10  psi_43      S  eta_3  eta_4  0.095484887 0.023763452
#11  psi_44      S  eta_4  eta_4 -0.788377570 0.155420468
#12 alpha_1      M      1  eta_1 58.643496029 0.263417303
#13 alpha_2      M      1  eta_2  1.737548338 0.023772691
#14 alpha_3      M      1  eta_3 -0.835980510 0.023120068
#15 alpha_4    a_4      1      1  7.513110932 0.091021073
#
#observed statistics:  581 
#estimated parameters:  15 
#degrees of freedom:  566 
#-2 log likelihood:  2243.425 
#number of observations:  83 
#Information Criteria: 
#      |  df Penalty  |  Parameters Penalty  |  Sample-Size Adjusted
#AIC:      1111.4251               2273.425                       NA
#BIC:      -257.6387               2309.708                 2262.394
#Some of your fit indices are missing.
#  To get them, fit saturated and independence models, and include them with
#  summary(yourModel, SaturatedLikelihood=..., IndependenceLikelihood=...). 
#timestamp: 2014-11-07 21:11:06 
#wall clock time: 0.30703 secs 
#optimizer:  CSOLNP 
#OpenMx version number: 2.0.0.3838 
#Need help?  See help(mxSummary) 




################# Spline Growth Model with Variation in Knot Point through Taylor Series Expansion ################# 
## Centered at the Knot Point ##

spl.hght.omx <- mxModel("Spline Growth Model, Path Specification",
 type="RAM", mxData(observed=hght_wide, type="raw"),
 manifestVars=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 latentVars=c('eta_1','eta_2','eta_3','eta_4'),

# Residual Variances
mxPath( from=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'), 
 arrows=2, free=TRUE, values=10, labels='theta'),

# Latent Variable Covariances 
mxPath(from=c('eta_1','eta_2','eta_3','eta_4'),connect='unique.pairs',
 arrows=2, free=TRUE, values = c(1,0,0,0,1,0,0,1,0,1),
 labels=c('psi_11','psi_21','psi_31','psi_41','psi_22','psi_32','psi_42','psi_33','psi_43','psi_44')),

# Factor Loadings
mxPath(from='eta_1', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE, values=1),

mxPath(from='eta_2', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE, 
 labels=c('L2[1,1]', 'L2[2,1]', 'L2[3,1]', 'L2[4,1]', 'L2[5,1]', 'L2[6,1]', 'L2[7,1]', 'L2[8,1]', 'L2[9,1]')),

mxPath(from='eta_3', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE,
 labels=c('L3[1,1]', 'L3[2,1]', 'L3[3,1]', 'L3[4,1]', 'L3[5,1]', 'L3[6,1]', 'L3[7,1]', 'L3[8,1]', 'L3[9,1]')),

mxPath(from='eta_4', to=c('hght01','hght03','hght06','hght09','hght12','hght15','hght18','hght24','hght36'),
 arrows=1, free=FALSE,
 labels=c('L4[1,1]', 'L4[2,1]', 'L4[3,1]', 'L4[4,1]', 'L4[5,1]', 'L4[6,1]', 'L4[7,1]', 'L4[8,1]', 'L4[9,1]')),

# Latent Variable Means
mxPath(from='one', to=c('eta_1','eta_2','eta_3'),
 arrows=1, free=TRUE, values=c(70, 2, 1),
 labels=c('alpha_1','alpha_2','alpha_3')),

# Functional Constraints
mxMatrix('Full', 9, 1, free = TRUE, values = 2, labels = 'alpha_2', name = 'a_2'),
mxMatrix('Full', 9, 1, free = TRUE, values = 1, labels = 'alpha_3', name = 'a_3'),
mxMatrix('Full', 9, 1, free = TRUE, values = 8, labels = 'alpha_4', name = 'a_4'),
mxMatrix('Full', 9, 1, free = FALSE, values = c(1,3,6,9,12,15,18,24,36), name = 'time'),

mxAlgebra(time-a_4, name='L2'),
mxAlgebra(sqrt((time-a_4)*(time-a_4)), name='L3'),
mxAlgebra((-a_2*sqrt((time-a_4)*(time-a_4))+a_3* time-a_3*a_4)/sqrt((time-a_4)*(time-a_4)), name='L4')

) # Close Model 

spl.hght.fit <- mxRun(spl.hght.omx)

summary(spl.hght.fit)

#free parameters:
#      name matrix    row    col     Estimate   Std.Error
#1    theta      S hght01 hght01  1.661465503 0.137646513
#2   psi_11      S  eta_1  eta_1  0.191539053 1.341670680
#3   psi_21      S  eta_1  eta_2 -0.142209176 0.080998332
#4   psi_22      S  eta_2  eta_2  0.003696130 0.007349124
#5   psi_31      S  eta_1  eta_3  0.164890612 0.075709024
#6   psi_32      S  eta_2  eta_3 -0.001171133 0.006771968
#7   psi_33      S  eta_3  eta_3  0.001057209 0.006856831
#8   psi_41      S  eta_1  eta_4 -2.140984463 0.364247999
#9   psi_42      S  eta_2  eta_4 -0.117773628 0.025813113
#10  psi_43      S  eta_3  eta_4  0.095484582 0.023766311
#11  psi_44      S  eta_4  eta_4 -0.788379534 0.155448369
#12 alpha_1      M      1  eta_1 71.697904690 0.327768283
#13 alpha_2      M      1  eta_2  1.737547837 0.023773026
#14 alpha_3      M      1  eta_3 -0.835980364 0.023120508
#15 alpha_4    a_4      1      1  7.513113584 0.091022273
#
#observed statistics:  581 
#estimated parameters:  15 
#degrees of freedom:  566 
#-2 log likelihood:  2243.425 
#number of observations:  83 
#Information Criteria: 
#      |  df Penalty  |  Parameters Penalty  |  Sample-Size Adjusted
#AIC:      1111.4251               2273.425                       NA
#BIC:      -257.6387               2309.708                 2262.394
#Some of your fit indices are missing.
#  To get them, fit saturated and independence models, and include them with
#  summary(yourModel, SaturatedLikelihood=..., IndependenceLikelihood=...). 
#timestamp: 2014-11-07 21:28:00 
#wall clock time: 0.290029 secs 
#optimizer:  CSOLNP 
#OpenMx version number: 2.0.0.3838 
#Need help?  See help(mxSummary) 

